* Smart and Illicit: Table 5, CPS

# delimit;
clear ;
clear matrix ;
set more off ;

clear mata ;

capture log close ;



global FOLDER    "/Users/yonarubinstein/Dropbox/SMART&ILLICIT_QJE/POST/TABLE 5/"  ;
global TABLEFILE "DATA FOR TABLE 5.dta" ;


cd "$FOLDER/" ;


log using "TABLE 5.log", replace ;



/* ********************************************************************************************************* */
/* ******************************************* UPLOAD WORKFILE ********************************************* */
/* ********************************************************************************************************* */


use "$FOLDER/$TABLEFILE", clear ;


replace _anhrslyrt1 = _anhrslyrt1/2000 ;

mlogit _CLASSWRKt $NR_t1 _educomp _female _black _hispanic _otherace _anhrslyrt1 _exp1-_exp4 i.year i.statefip  if _panel1==1 & _anhrslyrt1~=. & _anhrslyrt1>0 & routine_t1~=. [aweight=wtsupp], robust cluster (year) ;
estimates store mlogit61, title((mlogit1));


estout mlogit61  using "$FOLDER/TABLE 5.txt", replace
keep (math_t1 dcp_t1 ehf_t1 _educomp _anhrslyrt1 _female _black _hispanic _otherace)
cells(b(star fmt(3)) se(par fmt (3)))
legend label varlabels(_cons Constant)  
stats(N r2 , fmt(0 3 0) labels(Observations R-square))
starlevels(* 0.10 ** 0.05 *** 0.01)
prehead("Table 5: Selection into Unincorporated and Incorporated Self-Employment, CPS ") 
posthead("")
prefoot("")
postfoot("" 
"Notes."
"TBA"
) ;



log close ;

